function y = k_off_integral_catch_bond_v4c(x, l_yield, k, k_off_1, k_off_2, F_d_1, F_d_2)

% The function calculates an integral from k_off(x) function

a_1 = k_off_1 * F_d_1 / k;
a_2 = k_off_2 * F_d_2 / k;

index_1 = x <= l_yield;
index_2 = ~index_1;

k_off_y = k_off_1 * exp( k * l_yield / F_d_1) + k_off_2 * exp( k * l_yield / F_d_2);

y(index_1) = a_1 * ( exp(k*x(index_1)/F_d_1) - 1 ) + a_2 * ( exp(k*x(index_1)/F_d_2) - 1 ); 
y(index_2) = a_1 * ( exp(k*l_yield/F_d_1) - 1 ) + a_2 * ( exp(k*l_yield/F_d_2) - 1 ) + k_off_y * (x(index_2) - l_yield);

end

